unit Form_SMTP_SakEMail;

{$I DICompilers.inc} // DIHtmlParser installed? Download from http://www.yunqa.de

interface

uses
  DISystemCompat, Classes, Forms, Dialogs, StdCtrls, Buttons, Controls, ExtCtrls, ComCtrls,
  // SakEmail - Download from http://groups.yahoo.com/group/sakemail/
  SakMsg, SakSMTP,
  // Acester Form
  form_SMTP_Base,
  // DIHtmlMimeMessage
  DIHtmlMimeMessage;

type
  TfrmSmtpSakEMail = class(TfrmSmtpBase)
    procedure DIHtmlMimeMessage1Attachment(
      const Sender: TDIHtmlMimeMessage;
      const AFullFileName, AFileExt: UnicodeString;
      var AContentID: UnicodeString;
      const TagID, AttribId: Cardinal;
      var Attach: Boolean);
    procedure DIHtmlMimeMessage1End(
      const HtmlBuf: Pointer;
      const HtmlBufSize: Cardinal);
    procedure btnSendClick(Sender: TObject);
    procedure DIHtmlMimeMessage1Begin;
    procedure FormCreate(Sender: TObject);
  private
    FSakMsg: TSakMsg;
    FSakSMTP: TSakSMTP;
    procedure OnSmtpError(Sender: TObject; Error: Integer; Msg: AnsiString);
  end;

var
  frmSmtpSakEMail: TfrmSmtpSakEMail;

implementation

uses
  SysUtils, TypInfo,

  SakAttFile;

{$R *.DFM}

//------------------------------------------------------------------------------

procedure TfrmSmtpSakEMail.FormCreate(Sender: TObject);
var
  p: TPriority;
begin
  inherited;

  FSakMsg := TSakMsg.Create(Self);
  FSakSMTP := TSakSMTP.Create(Self);
  FSakSMTP.OnError := OnSmtpError;

  for p := Low(TPriority) to High(TPriority) do
    cboPriority.Items.Add(GetEnumName(TypeInfo(TPriority), Ord(p)));
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSakEMail.btnSendClick(Sender: TObject);
begin
  btnSend.Enabled := False;
  try
    Status('Preparing message ...');

    FSakMsg.From := edtFrom.Text;
    FSakMsg.ReplyTo := edtFrom.Text;
    FSakMsg.SendTo := edtTo.Text;
    FSakMsg.cc := edtCC.Text;
    FSakMsg.bcc := edtBCC.Text;
    FSakMsg.Subject := edtSubject.Text;
    if cboPriority.ItemIndex >= 0 then
      FSakMsg.Priority := TPriority(cboPriority.ItemIndex);

    { Call DIIndyHtmlMimeMessage to fill the message with the HTML document and
      all linked files as atatchments. }
    DIHtmlMimeMessage1.FillFromFile(edtHtmlFileName.Text);

    FSakSMTP.Host := edtSmtpServerName.Text;
    FSakSMTP.Port := edtSmtpServerPort.Text;

    Status('Sending message ...');

    if FSakSMTP.Connect then
      try
        if cboSmtpServerAuthType.ItemIndex = 1 then
          begin
            FSakSMTP.UserId := edtSmtpUserName.Text;
            FSakSMTP.UserPasswd := edtSmtpPassword.Text;
            if not FSakSMTP.Login then
              begin
                ShowMessage('AUTH Login Failed - Disconnecting.');
                Exit;
              end;
          end;

        if not FSakSMTP.SMTPError then
          begin
            if not FSakSMTP.SendTheMessage(FSakMsg) then
              begin
                ShowMessage('Error sending message.');
              end;
          end;

      finally
        FSakSMTP.Disconnect;
      end
    else
      begin
        ShowMessage('Error connecting to server.');
      end;

  finally
    Status('');
    btnSend.Enabled := True;
  end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSakEMail.DIHtmlMimeMessage1Begin;
begin
  // Clear the message. Unfortunately, there is no TSakMsg.Clear procedure (yet).
  FSakMsg.ClearRawMail;
  FSakMsg.Text.Clear;
  FSakMsg.Html.Clear;
  FSakMsg.AttachedFiles.Clear;
  FSakMsg.HtmlCharSet := 'ISO-8859-1';
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSakEMail.DIHtmlMimeMessage1Attachment(
  const Sender: TDIHtmlMimeMessage;
  const AFullFileName, AFileExt: UnicodeString;
  var AContentID: UnicodeString;
  const TagID, AttribId: Cardinal;
  var Attach: Boolean);
var
  Attachment: TAttachedFile;
begin
  Attachment := FSakMsg.AttachedFiles.Add(AFullFileName);
  Attachment.FileName := AContentID;
  Attachment.ContentID := AContentID;
  Attachment.Embedded := True;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSakEMail.DIHtmlMimeMessage1End(const HtmlBuf: Pointer; const HtmlBufSize: Cardinal);
var
  s: AnsiString;
begin
  SetString(s, PAnsiChar(HtmlBuf), HtmlBufSize);
  FSakMsg.Html.Text := s;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSakEMail.OnSmtpError(Sender: TObject; Error: Integer; Msg: AnsiString);
begin
  ShowMessage('Error: ' + Msg);
end;

end.

