unit Form_SMTP_iPro;

{$I DICompilers.inc} // DIHtmlParser installed? Download from http://www.yunqa.de

interface

uses
  DISystemCompat, Classes, Forms, Dialogs, StdCtrls, Buttons, Controls, ExtCtrls, ComCtrls,
  // iPro - Download from http://sourceforge.net/projects/tpipro/
  IpSmtp,
  // Acester Base Form
  form_SMTP_Base,
  // DIHtmlMimeMessage
  DIHtmlMimeMessage;

type
  TfrmSmtpIPro = class(TfrmSmtpBase)
    procedure DIHtmlMimeMessage1Attachment(
      const Sender: TDIHtmlMimeMessage;
      const AFullFileName, AFileExt: UnicodeString;
      var AContentID: UnicodeString;
      const TagID, AttribId: Cardinal;
      var Attach: Boolean);
    procedure DIHtmlMimeMessage1End(
      const HtmlBuf: Pointer;
      const HtmlBufSize: Cardinal);
    procedure btnSendClick(Sender: TObject);
    procedure IpSmtpClient1Error(Sender: TObject; Socket: Cardinal;
      ErrCode: Integer; const ErrStr: AnsiString);
    procedure IpSmtpClient1ConnectError(Client: TIpCustomSmtpClient;
      ErrCode: Integer; const ErrStr: AnsiString);
    procedure FormCreate(Sender: TObject);
  private
    FIpSmtpClient: TIpSmtpClient;
  end;

var
  frmSmtpIPro: TfrmSmtpIPro;

implementation

uses
  SysUtils,
  IpMsg;

{$R *.DFM}

//------------------------------------------------------------------------------

procedure TfrmSmtpIPro.FormCreate(Sender: TObject);
begin
  inherited;
  FIpSmtpClient := TIpSmtpClient.Create(Self);
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIPro.btnSendClick(Sender: TObject);
begin
  btnSend.Enabled := False;
  try
    Status('Preparing message ...');

    FIpSmtpClient.Message.NewMessage;
    FIpSmtpClient.Message.ContentType := 'multipart';
    FIpSmtpClient.Message.ContentSubtype := 'related';

    FIpSmtpClient.Message.From := edtFrom.Text;
    FIpSmtpClient.Message.MailTo.Text := edtTo.Text;
    FIpSmtpClient.Message.cc.Text := edtCC.Text;
    FIpSmtpClient.Message.bcc.Text := edtBCC.Text;
    FIpSmtpClient.Message.Subject := edtSubject.Text;

    if chkReturnReciept.Checked then
      FIpSmtpClient.Message.DispositionNotification := edtFrom.Text
    else
      FIpSmtpClient.Message.DispositionNotification := '';

    { Create a text/html mime entry as the first entry. }
    FIpSmtpClient.Message.GetBodyHtml(True);

    { Call DIHtmlMimeMessage to fill the message with the HTML document and
      all linked files as atatchments. }
    DIHtmlMimeMessage1.FillFromFile(edtHtmlFileName.Text);

    {$IFDEF DI_Debug}
    FIpSmtpClient.Message.SaveToFile('c:\temp\iPro_Message.txt');
    {$ENDIF Debug}

    Status('Sending message ...');

    FIpSmtpClient.DefaultPort := StrToInt(edtSmtpServerPort.Text);
    FIpSmtpClient.UserId := edtSmtpUserName.Text;
    FIpSmtpClient.Password := edtSmtpPassword.Text;
    FIpSmtpClient.EnableAuth := cboSmtpServerAuthType.ItemIndex = 1;
    FIpSmtpClient.SendMail(edtSmtpServerName.Text, True);
  finally
    Status('');
    btnSend.Enabled := True;
  end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIPro.DIHtmlMimeMessage1Attachment(
  const Sender: TDIHtmlMimeMessage;
  const AFullFileName, AFileExt: UnicodeString;
  var AContentID: UnicodeString;
  const TagID, AttribId: Cardinal;
  var Attach: Boolean);
var
  MimeEntry: TIpMimeEntity;
begin
  MimeEntry := FIpSmtpClient.Message.NewMimePart;
  MimeEntry.ContentDispositionType := 'inline';
  MimeEntry.EntityName := AContentID;
  MimeEntry.ContentID := AContentID;
  MimeEntry.EncodeBodyFile(AFullFileName);
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIPro.DIHtmlMimeMessage1End(const HtmlBuf: Pointer; const HtmlBufSize: Cardinal);
var
  s: TMemoryStream;
  HtmlBodyMimeEntry: TIpMimeEntity;
begin
  s := TMemoryStream.Create;
  try
    s.Write(HtmlBuf^, HtmlBufSize);
    s.Seek(0, soFromBeginning);
    HtmlBodyMimeEntry := FIpSmtpClient.Message.GetBodyHtml(True);
    HtmlBodyMimeEntry.ContentTransferEncoding := emquoted;
    HtmlBodyMimeEntry.EncodeBodyStream(s, '');
  finally
    s.Free;
  end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIPro.IpSmtpClient1Error(Sender: TObject; Socket: Cardinal; ErrCode: Integer; const ErrStr: AnsiString);
begin
  ShowMessage(ErrStr);
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIPro.IpSmtpClient1ConnectError(Client: TIpCustomSmtpClient; ErrCode: Integer; const ErrStr: AnsiString);
begin
  ShowMessage(ErrStr);
end;

end.

