unit Form_SMTP_Synapse;

{$I DICompilers.inc} // DIHtmlParser installed? Download from http://www.yunqa.de

interface

uses
  DISystemCompat, Classes, Forms, Controls, Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons,
  // Ancestor Base Form
  form_SMTP_Base,
  // Synapse - Download from http://synapse.ararat.cz/
  MimePart, MimeMess,
  // DIHtmlMimeMessage
  DIHtmlMimeMessage;

type
  TfrmSmtpSynapse = class(TfrmSmtpBase)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure DIHtmlMimeMessage1Attachment(
      const Sender: TDIHtmlMimeMessage;
      const AFullFileName, AFileExt: UnicodeString;
      var AContentID: UnicodeString;
      const TagID, AttribId: Cardinal;
      var Attach: Boolean);
    procedure DIHtmlMimeMessage1End(
      const AHtmlBuf: Pointer;
      const AHtmlBufSize: Cardinal);
  private
    FMessage: TMimeMess;
    FMultiPartMixed: TMimePart;
    FMultiPartAlternative: TMimePart;
    FMultiPartRelated: TMimePart;
    FHtmlPart: TMimePart;
  public

  end;

var
  frmSmtpSynapse: TfrmSmtpSynapse;

implementation

{$R *.DFM}

uses
  SysUtils, SmtpSend;

procedure TfrmSmtpSynapse.FormCreate(Sender: TObject);
begin
  inherited;
  FMessage := TMimeMess.Create;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSynapse.FormDestroy(Sender: TObject);
begin
  FMessage.Free;
  inherited;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSynapse.btnSendClick(Sender: TObject);
var
  Text: TStringList;
begin
  btnSend.Enabled := False;
  try
    Status('Preparing message ...');

    FMessage.Clear;

    FMultiPartMixed := FMessage.AddPartMultipart('mixed', nil);
    FMultiPartRelated := FMessage.AddPartMultipart('related', FMultiPartRelated);
    FMultiPartAlternative := FMessage.AddPartMultipart('alternative', FMultiPartRelated);

    { Make sure that the HTML part is the first part of our message.
      At this point, the modified HTML contents is not yet available,
      so we add an empty part and fill it later on (below). }
    Text := TStringList.Create;
    try
      { Add plain text part - for demonstration only.  }
      Text.Add('This is an HTML message. Upgrade you e-mail client if you can read this!');
      FMessage.AddPartText(Text, FMultiPartAlternative);
      { Add HTML part. Fill contents in DIHtmlMimeMessage1End. }
      Text.Clear;
      FHtmlPart := FMessage.AddPartHTML(Text, FMultiPartAlternative);
    finally
      Text.Free;
    end;

    { Invoke TDIHtmlMimeMessage to parse the HTML file and call its events. }
    DIHtmlMimeMessage1.FillFromFile(edtHtmlFileName.Text);

    { Assemble the Message's header. }
    FMessage.Header.From := edtFrom.Text;
    FMessage.Header.ToList.Text := edtTo.Text;
    FMessage.Header.CCList.Text := edtCC.Text;
    FMessage.Header.Subject := edtSubject.Text;

    { Remember to encode the message, otherwise it will be empty. }
    FMessage.EncodeMessage;

    Status('Sending message ...');

    { At last: Send the message. }
    if not sendtoraw(
      edtFrom.Text,
      edtTo.Text,
      edtSmtpServerName.Text + ':' + edtSmtpServerPort.Text,
      FMessage.Lines,
      edtSmtpUserName.Text,
      edtSmtpPassword.Text) then
      ShowMessage('Error sending message.');
  finally
    Status('');
    btnSend.Enabled := True;
  end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSynapse.DIHtmlMimeMessage1Attachment(
  const Sender: TDIHtmlMimeMessage;
  const AFullFileName, AFileExt: UnicodeString;
  var AContentID: UnicodeString;
  const TagID, AttribId: Cardinal;
  var Attach: Boolean);
var
  MP: TMimePart;
begin
  { Add the contents of the file as an inline HTML attachment. }
  MP := FMessage.AddPartHTMLBinaryFromFile(
    AFullFileName, AContentID, FMultiPartRelated);
  { Correct Content-Type for *.css. Synapse's incorrectly defaults it to
    "application/octet-stream". }
  if CompareText(AFileExt, '.css') = 0 then
    begin
      MP.primary := 'text';
      MP.secondary := 'css';
      MP.EncodePartHeader;
    end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpSynapse.DIHtmlMimeMessage1End(
  const AHtmlBuf: Pointer;
  const AHtmlBufSize: Cardinal);
begin
  { Write the modified HTML document with adjusted inline links
    to the HTML part and encode it. }
  FHtmlPart.DecodedLines.Write(AHtmlBuf^, AHtmlBufSize);
  FHtmlPart.EncodePart;
end;

end.

